/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureBasic;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiBasicStructure
extends GuiStructure {
    protected BasicStructureConfiguration configuration;
    private GuiButtonExt btnBedColor = null;
    private GuiButtonExt btnGlassColor = null;
    private GuiButtonExt btnStructureOptions = null;
    private ArrayList<BaseOption> availableOptions;
    private boolean showConfigurationOptions;
    private int imagePanelUpperLeft;

    public GuiBasicStructure() {
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.Basic;
        this.showConfigurationOptions = false;
    }

    @Override
    protected void Initialize() {
        super.Initialize();
        ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(this.player);
        if (stack != null) {
            ItemBasicStructure item = (ItemBasicStructure)stack.func_77973_b();
            this.configuration = ClientEventHandler.playerConfig.getClientConfig(item.structureType.getName(), BasicStructureConfiguration.class);
            this.configuration.basicStructureName = item.structureType;
            if (this.configuration.chosenOption.getClass() != item.structureType.getBaseOption().getClass()) {
                this.configuration.chosenOption = item.structureType.getBaseOption();
            }
            this.structureImageLocation = this.configuration.chosenOption.getPictureLocation();
            this.availableOptions = this.configuration.chosenOption.getSpecificOptions();
        }
        this.configuration.pos = this.pos;
        if (this.availableOptions.size() > 1 || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.WatchTower || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.WelcomeCenter || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.VillagerHouses || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.AdvancedWarehouse || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.Warehouse || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.ProduceFarm || this.configuration.basicStructureName == BasicStructureConfiguration.EnumBasicStructureName.MonsterMasher) {
            this.showConfigurationOptions = true;
        }
        if (!this.showConfigurationOptions) {
            this.InitializeStandardButtons();
        } else {
            this.modifiedInitialXAxis = 212;
            this.modifiedInitialYAxis = 117;
            this.imagePanelWidth = 285;
            Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
            int grayBoxX = adjustedXYValue.getFirst();
            int grayBoxY = adjustedXYValue.getSecond();
            int x = grayBoxX + 15;
            int y = grayBoxY + 45;
            if (this.availableOptions.size() > 1) {
                this.btnStructureOptions = this.createAndAddButton(7, x, y, 100, 20, this.configuration.chosenOption.getTranslationString());
                this.btnStructureOptions.field_146125_m = true;
                y += 45;
            } else if (this.btnStructureOptions != null) {
                this.btnStructureOptions.field_146125_m = false;
            }
            this.btnBedColor = this.createAndAddDyeButton(5, x, y, 90, 20, this.configuration.bedColor);
            this.btnBedColor.field_146125_m = false;
            this.btnGlassColor = this.createAndAddFullDyeButton(6, x, y, 90, 20, this.configuration.glassColor);
            this.btnGlassColor.field_146125_m = false;
            this.btnVisualize = this.createAndAddCustomButton(3, grayBoxX + 25, grayBoxY + 175, 90, 20, "prefab.gui.button.preview");
            this.btnBuild = this.createAndAddCustomButton(1, grayBoxX + 310, grayBoxY + 175, 90, 20, "prefab.gui.button.build");
            this.btnCancel = this.createAndAddButton(2, grayBoxX + 150, grayBoxY + 175, 90, 20, "prefab.gui.button.cancel");
        }
    }

    @Override
    protected void preButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (!this.showConfigurationOptions) {
            super.preButtonRender(x, y, mouseX, mouseY, partialTicks);
        } else {
            int imagePanelUpperLeft = x + 132;
            int imagePanelMiddle = this.imagePanelWidth / 2;
            this.func_146276_q_();
            this.drawControlLeftPanel(x + 10, y + 10, 125, 190);
            this.drawControlRightPanel(imagePanelUpperLeft, y + 10, this.imagePanelWidth, 190);
            int middleOfImage = this.shownImageWidth / 2;
            int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
            GuiUtils.bindTexture(this.structureImageLocation);
            Gui.func_152125_a((int)imageLocation, (int)(y + 15), (float)0.0f, (float)0.0f, (int)this.shownImageWidth, (int)this.shownImageHeight, (int)this.shownImageWidth, (int)this.shownImageHeight, (float)this.shownImageWidth, (float)this.shownImageHeight);
        }
        if (this.btnBedColor != null) {
            this.btnBedColor.field_146125_m = false;
        }
        if (this.btnGlassColor != null) {
            this.btnGlassColor.field_146125_m = false;
        }
        int yValue = y + 45;
        if (this.availableOptions.size() > 1) {
            yValue += 45;
        }
        if (this.configuration.chosenOption.getHasBedColor()) {
            this.btnBedColor.field_146125_m = true;
            this.btnBedColor.field_146129_i = yValue;
            yValue += 45;
        }
        if (this.configuration.chosenOption.getHasGlassColor()) {
            this.btnGlassColor.field_146125_m = true;
            this.btnGlassColor.field_146129_i = yValue;
        }
    }

    @Override
    protected void postButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.showConfigurationOptions) {
            this.drawString(GuiLangKeys.translateString(this.configuration.basicStructureName.getItemTranslationString()), x + 15, y + 17, this.textColor);
            int yValue = y + 35;
            if (this.availableOptions.size() > 1) {
                this.drawString(GuiLangKeys.translateString("prefab.gui.building_options"), x + 15, yValue, this.textColor);
                yValue += 45;
            }
            if (this.configuration.chosenOption.getHasBedColor()) {
                this.drawString(GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 15, yValue, this.textColor);
                yValue += 45;
            }
            if (this.configuration.chosenOption.getHasGlassColor()) {
                this.drawString(GuiLangKeys.translateString("prefab.gui.structure.glass"), x + 15, yValue, this.textColor);
                yValue += 45;
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnVisualize) {
            StructureBasic structure = (StructureBasic)StructureBasic.CreateInstance(this.configuration.chosenOption.getAssetLocation(), StructureBasic.class);
            this.performPreview(structure, this.configuration);
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = EnumDyeColor.func_176764_b((int)(this.configuration.bedColor.func_176765_a() + 1));
            GuiUtils.setButtonText((GuiButton)this.btnBedColor, GuiLangKeys.translateDye(this.configuration.bedColor));
        } else if (button == this.btnGlassColor) {
            this.configuration.glassColor = FullDyeColor.ById(this.configuration.glassColor.getId() + 1);
            GuiUtils.setButtonText((GuiButton)this.btnGlassColor, GuiLangKeys.translateFullDye(this.configuration.glassColor));
        } else if (button == this.btnStructureOptions) {
            for (int i = 0; i < this.availableOptions.size(); ++i) {
                BaseOption option = this.availableOptions.get(i);
                BaseOption chosenOption = null;
                if (this.configuration.chosenOption.getTranslationString().equals(option.getTranslationString())) {
                    chosenOption = i == this.availableOptions.size() - 1 ? this.availableOptions.get(0) : this.availableOptions.get(i + 1);
                }
                if (chosenOption == null) continue;
                this.configuration.chosenOption = chosenOption;
                this.structureImageLocation = this.configuration.chosenOption.getPictureLocation();
                GuiUtils.setButtonText((GuiButton)this.btnStructureOptions, GuiLangKeys.translateString(chosenOption.getTranslationString()));
                break;
            }
        }
    }
}

